<?php

require_once Bank::CLIENT_DIR . "/ClientWidget.php";

Events::addListener('udash:pages/index', function() {

    # User Info 
    $user = Uss::$global['user'];
    $bankinfo = Uss::$global['usermeta']->get('bank:info', $user['id']);
    $bankNumber = Uss::$global['usermeta']->get('bank:number', $user['id']);
    
    # Avail Currencies;
    $defaultCode = $bankinfo['system']['currency'];
    $currencies = Uss::$global['options']->get("bank:currencies");

?>

<div class='container-fluid'>

    <h1 class='display-6 mb-4'>
        <h3>Welcome <strong>%{user.firstname}</strong></h3>
    </h1>
    
    <?php (new ClientWidget())->tradingView(); ?>
    
    <div class='py-4 mb-3'>
        <div class='card'>
            <div class='card-body'>
                <h5>Receive Money</h5>
                <div>Account Name: %{user.firstname} %{user.lastname}</div>
                <div>Account Number: %{user.bank_number}</div>
            </div>
        </div>
    </div>

    <h5 class='mb-2'>Your Balances:</h5>

    <div class='row mb-5'>
        <div class='col-lg-8 mb-4'>
            <div class='row'>

                <?php 
                    
                    usort($currencies, function($a, $b) use($defaultCode) {
                        if( $a['code'] == $defaultCode ) {
                            return -1;
                        } elseif( $b['code'] == $defaultCode ) {
                            return 1;
                        };
                        return 0;
                    });

                    foreach( $currencies as $currency ): 
                        
                        $isDefault = $defaultCode == $currency['code'];
                        $fiatBalance = Bank::getUserBalance( $user['id'], $currency['code'] );

                        $exchangeURL = Core::url( ROOT_DIR . "/" . UDASH_ROUTE . "/monetary/exchange" );

                ?>
                    <div class='col-sm-6 col-md-4 mb-3'>
                        <div class='card'>
                            <div class='card-body'>
                                <h5 class='mb-2'><?php echo $currency['name']; ?></h5>
                                <p class='text-muted text-uppercase'>Available Balance</p>
                                <h3 class='text-truncate'><?php echo $currency['symbol'] . number_format($fiatBalance, 2); ?></h3>
                                <?php if( $isDefault ): ?>
                                    <div class='py-1 text-end text-muted'>
                                        <small><i class='bi bi-arrow-up-right'></i> Default </small>
                                    </div>
                                <?php else: ?>
                                    <div class='py-1 text-end'>
                                        <small>
                                            <a href='<?php echo $exchangeURL; ?>'>
                                                <i class='bi bi-arrow-up-right'></i> Exchange
                                            </a>
                                        </small>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>

            </div>
        </div>

        <div class='col-lg-4'>
            <?php
                require Bank::CLIENT_DIR . "/misc/exc.rates.php"; 
            ?>
        </div>

    </div>

    <div class='row'>
        <div class='col-lg-12'>
            
<h5>Current Trading Indices:</h5>
            
<?php (new ClientWidget())->tradeIndices(); ?>
            
            <br> </br>

            <h5>Recent Transactions:</h5>

            <?php

                $SQL = "
                    SELECT 
                        %{prefix}_transfer_meta.*,
                        %{prefix}_transfers.tx_date,
                        %{prefix}_transfers.currency,
                        %{prefix}_transfers.amount as principal
                    FROM
                        %{prefix}_transfer_meta
                    INNER JOIN
                        %{prefix}_transfers
                    ON %{prefix}_transfer_meta.tx_ref = %{prefix}_transfers.tx_ref
                    WHERE
                        %{prefix}_transfer_meta.account_number = '%{account_number}'
                    ORDER BY %{prefix}_transfers.tx_date DESC
                ";

                $SQL = Core::replace_var( $SQL, [
                    'prefix' => DB_TABLE_PREFIX,
                    'account_number' => $bankNumber
                ]);

                $result = Uss::$global['mysqli']->query( $SQL );

                $tablet = new DOMTablet( 'tx' );

                $tablet->data( $result );

                $tablet->chunk(7);

                $tablet->columns([
                    'account_number' => 'account',
                    'principal' => 'amount',
                    'type',
                    'tx_date' => 'date', 
                ]);

                $tablet->wrap();

                $tablet->paginate( false );
                
                $tableClass = $tablet->table->getAttribute('class');
                $tablet->table->setAttribute('class', "{$tableClass} table-striped");

                $tablet->prepare(function($data) {

                    $color = Udash::get_color( $data['tx_type']  == 'credit' ? 'success' : 'danger' );
                    $data['type'] = "<span class='badge bg-{$color}'>{$data['tx_type']}</span>";

                    if( $data['currency'] == 'USD' ) {
                        $bankinfo = Uss::$global['usermeta']->get('bank:info', Uss::$global['user']['id']);
                        $code = $bankinfo['system']['currency'];
                    } else $code = $data['currency'];

                    $conversion = (new Converter())
                        ->from( 'USD' )
                        ->to( $code )
                        ->amount( $data['principal'] )
                        ->convert();
                    
                    $sign = ($data['tx_type'] == 'credit') ? null : '-';
                    $data['principal'] = $sign . $conversion->symbol . number_format($conversion->amount, 2);

                    return $data;

                }, true);

            ?>

        </div>
    </div>

</div>

<?php });