<form method='POST' enctype='multipart/form-data'>

    <div class='container-fluid'>
        <div class='row'>

            <div class='col-lg-5 mb-4'>
                <div class='card'>
                    <div class='card-body'>
                        
                            <fieldset class='p-3'> 

                                <div class='mb-3'>
                                    <label class='form-label'>Type</label>
                                    <select name='medium' class='form-select' value='%{gateway-medium}'>
                                        <option value='crypto'>Crypto</option>
                                        <option value='bank'>Bank</option>
                                    </select>
                                </div>

                                <div class='mb-3'>
                                    <label class='form-label'>Gateway Abbr <span class='text-muted'>(optional)</span></label>
                                    <input type='text' name='network' class='form-control' placeholder='e.g BTC' value='%{gateway-network}'>
                                </div>

                                <div class='mb-3'>
                                    <label class='form-label --required'>Gateway Name</label>
                                    <input type='text' name='name' class='form-control' placeholder='e.g Bank' required value='%{gateway-name}'>
                                </div>

                                <div class='mb-3'>
                                    <label class='form-label'>Gateway Icon</label>
                                    <input type='file' name='icon' class='form-control mb-1' accept='.jgp,.jpeg,.png,.webp,.gif' data-uss-image-preview='#img'>
                                    <div><img src='%{gateway-icon}' class='img-fluid' width='130px' id='img'></div>
                                </div>

                                <div class='mb-3'>
                                    <label class='form-label'>Status</label>
                                    <select name='status' class='form-select' value='%{gateway-status}'>
                                        <option value='1'>Active</option>
                                        <option value='0'>Inactive</option>
                                    </select>
                                </div>

                                <input type='hidden' name='id' value='%{gateway-id}'>

                            </fieldset>

                    </div>
                </div>
            </div>

            <div class='col-lg-7'>

                <div class='card mb-3'>
                    <div class='card-body'>

                        <fieldset>

                            <h4 class='fw-light'>Additional Detail:</h4>

                            <hr/>

                            <div class='alert alert-info'>
                                <i class='bi bi-info-circle me-1'></i> 
                                <small>This may include wallet address or bank information such as account number, swift code, etc</small>
                            </div>

                            <hr>

                            <div id='template-block'></div>

                            <hr>

                            <div class='text-center'>
                                <button class='btn btn-danger' type='button' id='add-template'>
                                    <i class='bi bi-plus-circle me-1'></i> Add Detail
                                </button>
                            </div>

                        </fieldset>

                    </div>  
                </div>

                <button class='btn btn-success w-100'>
                    Submit
                </button>

            </div>

        </div>
    </div>

</form>

<div class='d-none' data-gateway-detail>%{gateway-detail}</div>

<template id='detail-template'>
    <div class='border text-bg-light rounded-1 p-3 mb-2' data-template>
        <div class='input-group mb-1'>
            <span class='input-group-text'>
                <i class='bi bi-info-circle me-1 text-info'></i> Title
            </span>
            <input type='text' class='form-control' name='detail[title][]' placeholder='Wallet address' data-name='title'>
        </div>
        <div class='input-group mb-1'>
            <span class='input-group-text'>
                <i class='bi bi-check-circle me-1 text-success'></i> Value
            </span>
            <input type='text' class='form-control' name='detail[value][]' placeholder='bc1qxy2kgdygjrsqt...' data-name='value'>
        </div>
        <div class='text-end'>
            <small>
                <a href='javascript:void(0)' data-delete class='text-danger'>
                    <i class='bi bi-trash'></i> Delete
                </a>
            </small>
        </div>
    </div>
</template>